<?php
session_start();
// Start Output Buffering (Good Practice)
ob_start();

// --- 1. Authentication & Connection Setup ---
if(!isset($_SESSION['prnc_id'])){ 
    if (ob_get_level() > 0) ob_end_clean();
    header("Location: principal_login.php"); 
    exit(); 
}

$adm_conn = mysqli_connect("localhost","thevkin_schlprincdb","VK_AutSchlDb","thevkin_schlprincdb");
if(!$adm_conn){ 
    error_log("Admin DB Connection Error: " . mysqli_connect_error());
    die("Database Connection Error."); 
}

if(!isset($_GET['id'])){ 
    die("Missing Admin ID for editing."); 
}

$id = $_GET['id'];
$msg = "";
$error_type = ""; // 'success' or 'error'

// --- 2. Initial Fetch ---
$stmt_select = $adm_conn->prepare("SELECT * FROM school_admins WHERE id=? LIMIT 1");
$stmt_select->bind_param("s", $id);
$stmt_select->execute();
$res = $stmt_select->get_result();

if(!$res || $res->num_rows == 0){ 
    $stmt_select->close();
    die("Record not found for ID: " . htmlspecialchars($id)); 
}
$row = $res->fetch_assoc();
$stmt_select->close();

// --- 3. Update Logic ---
if(isset($_POST['update_admin'])){
    
    // Sanitize and trim inputs
    $name = trim($_POST['name']);
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password_raw = trim($_POST['password']); // Raw password from form (can be empty)
    $password_update_flag = false;
    
    // Determine the password to use for the update
    if (!empty($password_raw)) {
        // A new password was provided: Hash it securely
        $password_to_save = password_hash($password_raw, PASSWORD_DEFAULT);
        $password_update_flag = true;
    } else {
        // No new password provided: keep the old hash (which is already in $row['password'])
        $password_to_save = $row['password']; 
    }

    // 1. Check uniqueness (exclude current admin)
    $stmt_check = $adm_conn->prepare("SELECT id FROM school_admins WHERE (username=? OR email=?) AND id!=? LIMIT 1");
    $stmt_check->bind_param("sss", $username, $email, $id);
    $stmt_check->execute();
    $chk_res = $stmt_check->get_result();
    
    if($chk_res && $chk_res->num_rows > 0){
        $msg = "Username or Email already used by another admin.";
        $error_type = "error";
    } else {
        // 2. Photo handling
        $photo_name = $row['photo']; // Start with current photo
        $upload_dir = 'uploads/school_admins/'; // Standardized directory
        
        if(!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }

        if(!empty($_FILES['photo']['name']) && $_FILES['photo']['error'] == 0){
            $ext = pathinfo($_FILES['photo']['name'], PATHINFO_EXTENSION);
            $valid_extensions = ["jpg", "jpeg", "png", "gif"];
            
            if (in_array(strtolower($ext), $valid_extensions) && @getimagesize($_FILES['photo']['tmp_name'])) {
                
                // Use a unique name for the new file
                $new_photo_name = preg_replace('/[^a-zA-Z0-9\._-]/', '_', $id) . "_" . time() . "." . strtolower($ext);
                $new_photo_path = $upload_dir . $new_photo_name;
                
                if(move_uploaded_file($_FILES['photo']['tmp_name'], $new_photo_path)){
                    // Photo upload successful: Delete old file and set new name
                    if(!empty($row['photo']) && file_exists($upload_dir . $row['photo']) && $row['photo'] != 'default.png'){
                        @unlink($upload_dir . $row['photo']);
                    }
                    $photo_name = $new_photo_path; // Store the full path
                } else {
                    $msg = "Error uploading photo. Changes were not saved.";
                    $error_type = "error";
                    // Photo name remains the old one ($row['photo']) in this error case
                }
            } else {
                 $msg = "Invalid file or file type. Only JPG, PNG, GIF allowed.";
                 $error_type = "error";
            }
        }

        // 3. Update database
        if($error_type == ""){ // Only proceed if no upload error occurred
            
            // Build the appropriate query based on if the password needs updating
            if ($password_update_flag) {
                // Update everything including the new HASHED password
                $update_sql = "UPDATE school_admins SET name=?, username=?, email=?, password=?, photo=? WHERE id=?";
                $stmt_update = $adm_conn->prepare($update_sql);
                $stmt_update->bind_param("ssssss", $name, $username, $email, $password_to_save, $photo_name, $id);
            } else {
                // Update everything BUT the password field
                $update_sql = "UPDATE school_admins SET name=?, username=?, email=?, photo=? WHERE id=?";
                $stmt_update = $adm_conn->prepare($update_sql);
                $stmt_update->bind_param("sssss", $name, $username, $email, $photo_name, $id);
            }

            if($stmt_update->execute()){
                $msg = "Admin details updated successfully.";
                $error_type = "success";
                
                // Refresh $row data from DB for form redisplay
                $stmt_refresh = $adm_conn->prepare("SELECT * FROM school_admins WHERE id=? LIMIT 1");
                $stmt_refresh->bind_param("s", $id);
                $stmt_refresh->execute();
                $res_refresh = $stmt_refresh->get_result();
                $row = $res_refresh->fetch_assoc();
                $stmt_refresh->close();
                
            } else {
                $msg = "Database Error: " . $stmt_update->error;
                $error_type = "error";
            }
            if (isset($stmt_update)) $stmt_update->close(); 
        }
    }
    if (isset($stmt_check)) $stmt_check->close();
}

// --- 4. Final Display Setup ---
// Current photo path setup (using the latest $row data)
$current_photo_path = $row['photo'];
if(empty($current_photo_path) || !file_exists($current_photo_path)) {
    // Check if the path is relative or full. Assuming the path stored in DB is relative to the root/uploads folder
    $full_path_check = $upload_dir . basename($current_photo_path);
    if (!file_exists($current_photo_path) && file_exists($full_path_check)) {
        $current_photo_path = $full_path_check;
    } else {
        $current_photo_path = "uploads/default.png";
    }
}

mysqli_close($adm_conn);
// Flush the output buffer
if (ob_get_level() > 0) ob_end_flush();
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Edit School Admin | <?php echo htmlspecialchars($row['id']); ?></title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">

<style>
/* --- Global Styles --- */
:root {
    --primary-color: #3b82f6; /* Brighter Blue */
    --secondary-color: #1e3a8a; /* Dark Blue */
    --accent-color: #f59e0b; /* Orange Accent */
    --bg-light: #eef2ff; /* Very Light Blue Background */
    --text-dark: #1f2937;
    --success-bg: #d1fae5;
    --success-text: #065f46;
    --error-bg: #fee2e2;
    --error-text: #991b1b;
}

body {
    font-family: 'Poppins', sans-serif;
    padding: 25px;
    background: var(--bg-light); 
    color: var(--text-dark);
    transition: background-color 0.3s;
}
.container {
    max-width: 700px;
    margin: 0 auto;
}
h2 {
    color: var(--secondary-color);
    margin-bottom: 25px;
    font-weight: 700;
    padding-bottom: 10px;
    border-bottom: 2px solid var(--primary-color);
    display: flex;
    align-items: center;
    gap: 10px;
}
h2 i {
    color: var(--primary-color);
}

/* --- Alerts --- */
.alert {
    padding: 12px 20px;
    border-radius: 8px;
    margin-bottom: 20px;
    font-weight: 500;
    opacity: 0; /* Start invisible for animation */
    animation: fadeIn 0.5s forwards 0.1s;
    display: flex;
    align-items: center;
    gap: 10px;
}
.alert::before {
    font-family: 'bootstrap-icons';
    font-size: 1.2rem;
}
.success-alert::before {
    content: "\f20e"; /* bi-check-circle-fill */
    color: var(--success-text);
}
.error-alert::before {
    content: "\f335"; /* bi-exclamation-octagon-fill */
    color: var(--error-text);
}

.success-alert {
    background-color: var(--success-bg);
    color: var(--success-text);
    border: 1px solid #a7f3d0;
}
.error-alert {
    background-color: var(--error-bg);
    color: var(--error-text);
    border: 1px solid #fecaca;
}
@keyframes fadeIn {
    to { opacity: 1; }
}

/* --- Form Card Styling --- */
.form-card {
    background: #ffffff;
    border-radius: 16px; /* Increased rounding */
    padding: 30px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.15); /* Deeper shadow */
    transition: transform 0.3s ease-out;
}
.form-card:hover {
    transform: translateY(-2px);
}

/* --- Form Elements --- */
label {
    display: block;
    margin-top: 18px;
    margin-bottom: 5px;
    font-weight: 600;
    color: var(--secondary-color);
    font-size: 0.95rem;
}
.form-group {
    margin-bottom: 15px;
}

.form-input {
    width: 100%;
    padding: 12px;
    border: 1px solid #e5e7eb;
    border-radius: 10px;
    font-size: 1rem;
    background-color: #f9fafb;
    transition: border-color 0.3s, box-shadow 0.3s, background-color 0.3s;
    box-sizing: border-box;
}
.form-input:hover {
    background-color: #fff;
}
.form-input:focus {
    border-color: var(--primary-color);
    box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.3); /* Stronger focus glow */
    outline: none;
    background-color: #fff;
}

/* --- Photo Preview --- */
.photo-preview {
    display: flex;
    align-items: center;
    gap: 20px;
    margin-bottom: 15px;
    padding: 10px;
    border: 1px dashed #d1d5db;
    border-radius: 10px;
    background-color: #fefefe;
}
.photo-preview img {
    width: 90px;
    height: 90px;
    border-radius: 50%;
    object-fit: cover;
    border: 5px solid var(--accent-color); /* Highlight color border */
    box-shadow: 0 0 0 3px #fff, 0 2px 8px rgba(0, 0, 0, 0.1);
    transition: transform 0.3s;
}
.photo-preview img:hover {
    transform: scale(1.05) rotate(2deg);
}

/* --- Button Styling (Animated) --- */
.btn-update {
    width: 100%;
    padding: 14px;
    background: var(--primary-color);
    color: #fff;
    border: none;
    border-radius: 10px;
    cursor: pointer;
    font-size: 1.1rem;
    font-weight: 600;
    margin-top: 30px;
    transition: background-color 0.3s, box-shadow 0.3s, transform 0.1s;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
}
.btn-update:hover {
    background-color: var(--secondary-color);
    box-shadow: 0 6px 15px rgba(30, 58, 138, 0.4);
}
.btn-update:active {
    transform: scale(0.98);
}

/* --- Media Queries for Mobile --- */
@media (max-width: 576px) {
    body {
        padding: 10px;
    }
    .form-card {
        padding: 20px 15px;
        border-radius: 12px;
    }
    h2 {
        font-size: 1.4rem;
        text-align: center;
        justify-content: center;
    }
    .photo-preview {
        flex-direction: column;
        text-align: center;
        gap: 10px;
    }
    .photo-preview p {
        font-size: 0.9rem;
    }
}
</style>
</head>
<body>
<div class="container">

<h2><i class="bi bi-pencil-square"></i> Edit School Admin (ID: <?php echo htmlspecialchars($row['id']); ?>)</h2>

<?php 
if(!empty($msg)) {
    $alert_class = $error_type == 'error' ? 'error-alert' : 'success-alert';
    echo "<div class='alert {$alert_class}'>{$msg}</div>";
}
?>

<div class="form-card">
    <form method="post" enctype="multipart/form-data">
        
        <div class="form-group">
            <label for="name">Full Name</label>
            <input type="text" id="name" name="name" class="form-input" value="<?php echo htmlspecialchars($row['name']); ?>" required>
        </div>

        <div class="form-group">
            <label for="username">Username</label>
            <input type="text" id="username" name="username" class="form-input" value="<?php echo htmlspecialchars($row['username']); ?>" required>
        </div>

        <div class="form-group">
            <label for="email">Email</label>
            <input type="email" id="email" name="email" class="form-input" value="<?php echo htmlspecialchars($row['email']); ?>" required>
        </div>

        <div class="form-group">
            <label for="password">Password</label>
            <input type="password" id="password" name="password" class="form-input" placeholder="Enter new password to change (Leave blank to keep current password)">
        </div>

        <div class="form-group">
            <label>Photo (Leave blank to keep current)</label>
            <div class="photo-preview">
                <img src='<?php echo htmlspecialchars($current_photo_path); ?>' alt='Current Photo'>
                <p>Current Admin Photo. Select a new file below to update it.</p>
            </div>
            <input type="file" name="photo" accept="image/*" class="form-input">
        </div>
        
        <button type="submit" name="update_admin" class="btn-update">
            <i class="bi bi-save-fill"></i> Save Changes
        </button>
    </form>
</div>
</div>
</body>
</html>